//
//  PGScheduleDelegate.h
//  EMPlaner
//
//  Created by Patrick Förster on 11.06.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class PGScheduleCell;
@class PGScheduleView;
@class PGScheduleSubcell;
@class PGCellIndex;
@class Match;

@protocol PGScheduleDelegate <NSObject>

-(NSUInteger) numberOfColumnsInScheduleView: (PGScheduleView*) view;
-(NSUInteger) numberOfRowsInScheduleView: (PGScheduleView*) view;

-(NSUInteger) scheduleView: (PGScheduleView*) view numberOfColumnsInRow: (NSUInteger) column;
-(NSUInteger) scheduleView:(PGScheduleView*) view numberOfCellsInRow: (NSUInteger) column;
-(Match*) scheduleView: (PGScheduleView*) view matchForIndex: (PGCellIndex*) cellIndex;
-(NSDictionary*) scheduleView: (PGScheduleView*) view detailsForIndex: (PGCellIndex*) indexPath;

-(void) setup: (PGScheduleSubcell*) cell withMatch: (Match*) match andDetails: (NSDictionary*) details;

-(void)scheduleView:(PGScheduleView *)view didSelectRowAtCellIndex:(PGCellIndex *) cellIndex withinFrame: (CGRect) frame;

@end
