//
//  PGEntitySetup.m
//  SimpleCoreDataExample
//
//  Created by Patrick Förster on 23.05.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGEntitySetup.h"
#import "PGAppDelegate.h"

@implementation PGEntitySetup

+(PGEntitySetup*) sharedInstance {
    static PGEntitySetup *sharedInstance = nil;
    if(!sharedInstance) {
        sharedInstance = [[PGEntitySetup alloc] init];
    }
    
    return sharedInstance;
}

-(NSDictionary*) setupDictionary {
    NSString* plistPath = [[NSBundle mainBundle] pathForResource:@"setup" ofType:@"plist"];        
    NSDictionary* dictonary = [[NSDictionary alloc] initWithContentsOfFile:plistPath];    

    return dictonary;
}

-(NSArray*) getMatchDetailsForGroup: (NSString*) group  {
    NSArray* temp = [[self setupDictionary] objectForKey:@"Matches"];
    
    NSMutableArray* result = [NSMutableArray array];
    
    for (NSDictionary* dict in temp) {
        if ([[dict objectForKey:@"group"] isEqualToString:group]) [result addObject:dict];
    }
    
    return result;
}

-(NSManagedObjectContext*) managedObjectContext {
    PGAppDelegate* delegate = [UIApplication sharedApplication].delegate;
    
    return delegate.managedObjectContext;
}

-(NSManagedObjectModel*) managedObjectModel {
    PGAppDelegate* delegate = [UIApplication sharedApplication].delegate;
    
    return delegate.managedObjectModel;
}

-(BOOL) isDatabaseInitialised {
    NSManagedObjectModel* model = [self managedObjectModel];
    NSFetchRequest* request = [model fetchRequestTemplateForName:@"initialisationCheck"];
    
    return [[self fetchArray:request] count] != 0;    
    
    /*
     programmatisch: 
    NSManagedObjectContext* ctx = [self managedObjectContext];
    
    NSEntityDescription *entityDescription = [NSEntityDescription entityForName:@"Team" inManagedObjectContext:ctx];
    NSFetchRequest *request = [[NSFetchRequest alloc] init];
    [request setEntity:entityDescription];
    
    NSPredicate *predicate = [NSPredicate predicateWithFormat: @"(name == %@)", @"Deutschland"];
    [request setPredicate:predicate];  
    
     return [[self fetchArray:request] count] != 0;    
     */
}

-(void) initialiseDatabase {
    if ([self isDatabaseInitialised]) return ;
    
    NSDictionary* dictionary = [self setupDictionary];

    // dieses dictionary speichert alle erstellten teams um später spieler und trainer hinzuzufügen
    NSDictionary* teams = [self createGroupsAndTeams:dictionary];

    // spieler & trainer erstellen
    NSDictionary* temp = [dictionary objectForKey:@"Teams"];
    if (temp) {
        NSEnumerator* enumerator = [temp keyEnumerator];

        id key;
        Team* team;
        NSDictionary* tDict;
        
        while ((key = [enumerator nextObject])) {
            if ([teams objectForKey:key] == nil) continue; // 
            
            team = [teams objectForKey:key];
            tDict = [temp objectForKey:key];
            
            NSArray* players = [tDict objectForKey:@"players"];
            for (NSDictionary* pDict in players) {
                Player* player = [self createPlayerFromDictionary:pDict];
             
                if (player) [team addPlayersObject:player];
            }
            
            Coach* coach = [self createCoachFromDictionary: [tDict objectForKey:@"coach"]];
            if (coach) [team setCoach:coach];
        }
    }
  
    NSArray* matches = [dictionary objectForKey:@"Matches"];
    for (NSDictionary* dict in matches) {
        [self createMatchFromDictionary:dict withTeams:teams];
    }
    
    NSError *error;
    if (![[self managedObjectContext] save:&error]) {
        // 
    }
}

-(NSDictionary*) createGroupsAndTeams: (NSDictionary*) dictionary {
    NSManagedObjectContext* ctx = [self managedObjectContext];    
    NSMutableDictionary* teams = [NSMutableDictionary dictionaryWithCapacity:16];
    NSDictionary* temp;
    
    // gruppen und manschaften erstellen
    temp = [dictionary objectForKey:@"Groups"];
    if (temp) {
        NSEnumerator* enumerator = [temp keyEnumerator];
        
        id key;
        Group* group;
        Team* team;
        
        NSArray* array;
        
        while ((key = [enumerator nextObject])) {
            group = [NSEntityDescription insertNewObjectForEntityForName:@"Group" inManagedObjectContext:ctx];
            
            group.name = key;
            
            array = [temp objectForKey:key];
            
            for (NSString* string in array) {
                team = [self createTeam:string];
                if (team) {
                    [group addTeamsObject:team];
                    [teams setObject:team forKey:string];
                }
            }
            
        }
    }
    
    return teams;
}

-(NSManagedObject*) initialiseHuman: (NSManagedObject*) human withDictionary: (NSDictionary*) dictionary {
    NSString* fullname = [dictionary objectForKey:@"name"];
    if (fullname) {
        NSArray* substrings = [fullname componentsSeparatedByString:@" "];
        if ([substrings count] <= 1) {
            [human setPrimitiveValue:@"" forKey:@"givenname"];
            [human setPrimitiveValue:fullname forKey:@"name"];
        }
        else {
            [human setPrimitiveValue:[substrings objectAtIndex:0] forKey:@"givenname"];
            NSMutableString* name = [NSMutableString string];
            for (int i = 1; i < [substrings count]; i++) {
                [name appendString:[substrings objectAtIndex:i]];
            }
            [human setPrimitiveValue:name forKey:@"name"];
        }
    }
    
    return human;
}

-(Coach*) createCoachFromDictionary: (NSDictionary*) dictionary {
    if (!dictionary) return nil;
    
    NSManagedObjectContext* ctx = [self managedObjectContext];    
    
    NSManagedObject* o = [NSEntityDescription insertNewObjectForEntityForName:@"Coach" inManagedObjectContext:ctx];    
    Coach* coach = (Coach*) [self initialiseHuman: o withDictionary:dictionary];   
    
    return coach;
}

-(Player*) createPlayerFromDictionary: (NSDictionary*) dictionary {
    if (!dictionary) return nil;
    
    NSManagedObjectContext* ctx = [self managedObjectContext];    
    
    Player* player = [NSEntityDescription insertNewObjectForEntityForName:@"Player" inManagedObjectContext:ctx];    
    player = (Player*) [self initialiseHuman: player withDictionary:dictionary];   
    player.number = [dictionary objectForKey:@"number"];
    player.position = [dictionary objectForKey:@"position"];
    player.club = [dictionary objectForKey:@"club"];
    
    return player;
}

-(Team*) createTeam: (NSString*) name {
    if (!name) return nil;
    
    NSManagedObjectContext* ctx = [self managedObjectContext];    

    Team* team = [NSEntityDescription insertNewObjectForEntityForName:@"Team" inManagedObjectContext:ctx];
    team.name = name;
    
    return team;
}

-(Match*) createMatchFromDictionary: (NSDictionary*) dictionary withTeams: (NSDictionary*) teams {
    if (!dictionary) return nil;
    
    NSManagedObjectContext* ctx = [self managedObjectContext];    
    
    Match* match = [NSEntityDescription insertNewObjectForEntityForName:@"Match" inManagedObjectContext:ctx];    
    NSString* homeName = [dictionary objectForKey:@"home"];
    NSString* guestName = [dictionary objectForKey:@"guest"];
    
    match.home = [teams objectForKey:homeName];
    match.guest = [teams objectForKey:guestName];
    match.date = [dictionary objectForKey:@"date"];
    match.stadion = [dictionary objectForKey:@"stadium"];
    match.group = [dictionary objectForKey:@"group"];
    
    return match;
}

-(NSArray*) fetchArray: (NSFetchRequest*) request {
    NSManagedObjectContext* ctx = [self managedObjectContext];
    
    NSError *error = nil;
    NSArray *array = [ctx executeFetchRequest:request error:&error];
    if (array == nil) {
        
        // errror handling
        
    }    
    
    return array;
}

-(NSArray*) fetchTeams {
    NSManagedObjectContext* ctx = [self managedObjectContext];

    NSEntityDescription *entityDescription = [NSEntityDescription entityForName:@"Team" inManagedObjectContext:ctx];
    NSFetchRequest *request = [[NSFetchRequest alloc] init];
    [request setEntity:entityDescription];    
    
    NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"name" ascending:YES];
    [request setSortDescriptors:[NSArray arrayWithObject:sortDescriptor]];
 
    return [self fetchArray:request];
}

-(Team*) fetchTeamWithIndexPath: (NSIndexPath*) index {
    NSManagedObjectContext* ctx = [self managedObjectContext];

    NSEntityDescription *entityDescription = [NSEntityDescription entityForName:@"Group" inManagedObjectContext:ctx];
    NSFetchRequest *request = [[NSFetchRequest alloc] init];
    [request setEntity:entityDescription];    
    
    NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"name" ascending:YES];
    [request setSortDescriptors:[NSArray arrayWithObject:sortDescriptor]];
    
    NSArray* groups = [self fetchArray:request];
    Group* group = [groups objectAtIndex:index.section];
    
    NSMutableArray* array = [NSMutableArray arrayWithCapacity:1];
    [array addObject:sortDescriptor];
    
    NSArray* teams = [group.teams sortedArrayUsingDescriptors:array];
    
    return [teams objectAtIndex:index.row];
}

-(NSArray*) fetchMatchesForGroup: (NSString*) group {
    /*
     
     programmatisch
     
    NSManagedObjectContext* ctx = [self managedObjectContext];
    
    NSEntityDescription *entityDescription = [NSEntityDescription entityForName:@"Match" inManagedObjectContext:ctx];
    NSFetchRequest *request = [[NSFetchRequest alloc] init];
    [request setEntity:entityDescription];    

    
    NSPredicate* precicate = [NSPredicate predicateWithFormat:@"group == %@", group];
    [request setPredicate: precicate];
     */
    
    NSDictionary* subs = [NSDictionary dictionaryWithObject:group forKey:@"GROUP"];

    NSFetchRequest* request = [self.managedObjectModel 
    fetchRequestFromTemplateWithName:@"MatchRequest" 
    substitutionVariables:subs];

    NSSortDescriptor *sortDescriptor = [[NSSortDescriptor alloc] initWithKey:@"date" ascending:YES];
    [request setSortDescriptors:[NSArray arrayWithObject:sortDescriptor]];
    
    return [self fetchArray:request];
}






@end
