//
//  PGEntitySetup.h
//  SimpleCoreDataExample
//
//  Created by Patrick Förster on 23.05.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#import "Match.h"
#import "Coach.h"
#import "Human.h"
#import "Group.h"
#import "Player.h"
#import "Team.h"

@interface PGEntitySetup : NSObject

+(PGEntitySetup*) sharedInstance;

-(NSDictionary*) setupDictionary;

-(NSArray*) getMatchDetailsForGroup: (NSString*) group;

-(NSManagedObjectContext*) managedObjectContext;
-(NSManagedObjectModel*) managedObjectModel;

-(BOOL) isDatabaseInitialised;
-(void) initialiseDatabase;

-(Team*) createTeam: (NSString*) name;
-(Player*) createPlayerFromDictionary: (NSDictionary*) dictionary;
-(Coach*) createCoachFromDictionary: (NSDictionary*) dictionary;
-(NSManagedObject*) initialiseHuman: (NSManagedObject*) human withDictionary: (NSDictionary*) dictionary;
-(Match*) createMatchFromDictionary: (NSDictionary*) dictionary withTeams: (NSDictionary*) teams;

-(NSArray*) fetchArray: (NSFetchRequest*) request;
-(NSArray*) fetchTeams;
-(Team*) fetchTeamWithIndexPath: (NSIndexPath*) index;
-(NSArray*) fetchMatchesForGroup: (NSString*) group;

@end
