//
//  PGTeamViewController.m
//  EMPlaner
//
//  Created by Patrick Förster on 11.06.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGTeamViewController.h"
#import "PGEntitySetup.h"
#import "PGTeamView.h"

@implementation PGTeamViewController

@synthesize team = _team;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}


- (void)viewDidLoad
{
    [super viewDidLoad];
    
    // customize view
    PGTeamView* view = (PGTeamView*) self.view;
    
    // header
    view.header.teamLabel.text = _team.name;
    view.header.flagView.image = [UIImage imageNamed:[NSString stringWithFormat:@"flag_%@.png", [_team.name lowercaseString]]];
    view.header.groupLabel.text = _team.group.name;
    
    // footer
    view.footer.coachLabel.text = [NSString stringWithFormat:@"%@ %@", 
                  [_team.coach valueForKey: @"givenname"], 
                  [_team.coach valueForKey: @"name"]];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 4;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    switch (section) {
        case 0: return [_team.pkeeper count];
        case 1: return [_team.pdefense count];
        case 2: return [_team.pcenter count];
        case 3: return [_team.pattack count];
    }
    
    return 0;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {    
    // es gibt nur einen Zellentype
    static NSString *cellIdentifier = @"Cell";
    
    // ist eine Zelle über?
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    
    // wenn nicht eine neue erstellen
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellIdentifier];
        
        cell.selectionStyle = UITableViewCellSelectionStyleGray;
    }
    
    // Zelle füllen
    Player* player = nil;
    switch (indexPath.section) {
        case 0: player = [_team.pkeeper objectAtIndex:indexPath.row]; break;
        case 1: player = [_team.pdefense objectAtIndex:indexPath.row]; break;
        case 2: player = [_team.pcenter objectAtIndex:indexPath.row]; break;
        case 3: player = [_team.pattack objectAtIndex:indexPath.row]; break;
    }
    
    if (player) {
        cell.textLabel.text = [NSString stringWithFormat:@"%@ %@", 
                               [player valueForKey: @"givenname"], 
                               [player valueForKey: @"name"]]; 
    }
    
    return cell;
}

-(NSString*) tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    switch (section) {
        case 0: return @"Torwart";
        case 1: return @"Abwehr";
        case 2: return @"Mittelfeld";
        case 3: return @"Angriff";
    }
    
    return nil;
}


#pragma mark - Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    // Navigation logic may go here. Create and push another view controller.
    /*
     <#DetailViewController#> *detailViewController = [[<#DetailViewController#> alloc] initWithNibName:@"<#Nib name#>" bundle:nil];
     // ...
     // Pass the selected object to the new view controller.
     [self.navigationController pushViewController:detailViewController animated:YES];
     */
}

@end
