//
//  PGTableViewController.m
//  EMPlaner
//
//  Created by Patrick Förster on 04.06.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGTableViewController.h"
#import "PGEntitySetup.h"
#import "PGTeamViewController.h"

@implementation PGTableViewController

- (id)initWithStyle:(UITableViewStyle)style
{
    self = [super initWithStyle:style];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];

    // Uncomment the following line to preserve selection between presentations.
    // self.clearsSelectionOnViewWillAppear = NO;
 
    // Uncomment the following line to display an Edit button in the navigation bar for this view controller.
    // self.navigationItem.rightBarButtonItem = self.editButtonItem;
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}

#pragma mark - Table view data source


- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    switch (self.view.tag) {
        case PG_GROUP_CONTROLLER: return 4;
        case PG_TEAM_CONTROLLER: return 1;
    }
    
    
    return 0;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    switch (self.view.tag) {
        case PG_GROUP_CONTROLLER: return 4;
        case PG_TEAM_CONTROLLER: return 16;
    }
    
    return 0;
}

-(Team*) getTeamForCellWithIndexPath: (NSIndexPath*) indexPath {
    Team* team;
    
    switch (self.view.tag) {
        case PG_GROUP_CONTROLLER: {
            team = [[PGEntitySetup sharedInstance] fetchTeamWithIndexPath:indexPath];
            
            break;
        }
        case PG_TEAM_CONTROLLER: {
            NSArray* teams = [[PGEntitySetup sharedInstance] fetchTeams];
            team = [teams objectAtIndex:indexPath.row];
            break;
        }
    }    
    
    return team;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *cellIdentifier = @"Cell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    
    // wenn nicht eine neue erstellen
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellIdentifier];
        
        //cell.selectionStyle = UITableViewCellSelectionStyleGray;
    }   

    Team* team = [self getTeamForCellWithIndexPath:indexPath];
    
    cell.textLabel.text = team.name;
    cell.imageView.image = [UIImage imageNamed:[NSString stringWithFormat: @"flag_%@.png", [team.name lowercaseString]]];
    
    return cell;
}

-(NSString*) tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
	switch (self.view.tag) {
        case PG_GROUP_CONTROLLER: return [NSString stringWithFormat:@"%c", (65 + section)];
    }
    
    return nil;
}

/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath
{
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/

/*
// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source
        [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view
    }   
}
*/

/*
// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath
{
}
*/

/*
// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath
{
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}
*/

#pragma mark - Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    PGTeamViewController* vcDetails = [self.storyboard instantiateViewControllerWithIdentifier:@"vc:details:team"];
    
    vcDetails.team = [self getTeamForCellWithIndexPath:indexPath];
    
    [self.navigationController pushViewController:vcDetails animated:YES];  

}

@end
