//
//  PGScheduleViewController.m
//  EMPlaner
//
//  Created by Patrick Förster on 11.06.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGScheduleViewController.h"
#import "PGEntitySetup.h"
#import "PGScheduleSubcell.h"

@implementation PGScheduleViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}

-(NSUInteger) numberOfColumnsInScheduleView: (PGScheduleView*) view {return 4;}

-(NSUInteger) numberOfRowsInScheduleView: (PGScheduleView*) view {return 4;}

-(NSUInteger) scheduleView: (PGScheduleView*) view numberOfColumnsInRow: (NSUInteger) column {
    switch (column) {
        case 0: case 1: return 5;
        case 2: return 2;
    }
    return 1;
}

-(NSUInteger) scheduleView:(PGScheduleView*) view numberOfCellsInRow: (NSUInteger) column {
    if (column == 0) return 6; else return 1;
}

-(NSString*) groupForRow: (NSUInteger) row andColumn: (NSUInteger) column {
    NSString* group;
    switch (row) {
        case 0: {
            group = [NSString stringWithFormat:@"%c", 65 + column];
            break;
        }
        case 1: {
            group = [NSString stringWithFormat:@"V%i", column + 1];
            break;
        }
        case 2: {
            group = [NSString stringWithFormat:@"H%i", column+1];
            break;
        }
        case 3: {
            group = [NSString stringWithFormat:@"F%i", column+1];
            break;
        }
    }    
    
    return group;    
}

-(Match*) scheduleView: (PGScheduleView*) view matchForIndex: (PGCellIndex*) cellIndex {
    NSString* group = [self groupForRow:cellIndex.row andColumn:cellIndex.column];
    
    NSArray* array = [[PGEntitySetup sharedInstance] fetchMatchesForGroup:group];
    
    return [array count] <= cellIndex.index ? nil : [array objectAtIndex:cellIndex.index];
}

-(NSDictionary*) scheduleView: (PGScheduleView*) view detailsForIndex: (PGCellIndex*) cellIndex {
    NSString* group = [self groupForRow:cellIndex.row andColumn:cellIndex.column];
    
    NSArray* array = [[PGEntitySetup sharedInstance] getMatchDetailsForGroup:group];
    
    return [array objectAtIndex: cellIndex.index];
}


-(void) setup: (PGScheduleSubcell*) cell withMatch: (Match*) match andDetails: (NSDictionary*) details {
    if (!match) return ;
    
    if (match.home) {
        cell.homeLabel.text = match.home.name;
        cell.homeFlag.image = [UIImage imageNamed:[NSString stringWithFormat: @"flag_%@.png", [match.home.name lowercaseString]]];
        
        if ([match.scoreHome intValue] != -1)
            cell.homeScore.text = [NSString stringWithFormat:@"%@", match.scoreHome];
    }
    else {
        cell.homeLabel.text = [details objectForKey:@"home"];
    }
    
    if (match.guest) {
        cell.guestLabel.text = match.guest.name;
        cell.guestFlag.image = [UIImage imageNamed:[NSString stringWithFormat: @"flag_%@.png", [match.guest.name lowercaseString]]];
        
        if ([match.scoreGuest intValue] != -1)
            cell.guestScore.text = [NSString stringWithFormat:@"%@", match.scoreGuest];
    }
    else {
        cell.guestLabel.text = [details objectForKey:@"guest"];  
    }
    
    NSNumber* minusOne = [NSNumber numberWithInt:-1]; 
    
    cell.homeScore.text = [match.scoreHome isEqualToNumber:minusOne] ? @"" : [match.scoreHome stringValue];
    cell.guestScore.text = [match.scoreHome isEqualToNumber:minusOne] ? @"" : [match.scoreGuest stringValue];
}

-(void)scheduleView:(PGScheduleView *)view didSelectRowAtCellIndex:(PGCellIndex *) cellIndex withinFrame: (CGRect) frame {
    
}

@end
