//
//  PGDetailsViewController.m
//  Kfz2
//
//  Created by Patrick Förster on 15.05.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGDetailsViewController.h"
#import "PGKfzLookup.h"

@interface PGDetailsViewController ()

@end

@implementation PGDetailsViewController

@synthesize selectionLabel = _selectionLabel;
@synthesize selection = _selection;


- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

-(CLLocationCoordinate2D) getCoordinatesForSelection: (NSString*)selection {
    CLLocationCoordinate2D location;
    
    selection =  [selection stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
    
    NSURL* googleAPI = [NSURL URLWithString:[NSString stringWithFormat:@"http://maps.google.com/maps/geo?q=%@&output=csv", selection]];
    
    NSError* error = nil;
    NSString* googleResult = [NSString stringWithContentsOfURL:googleAPI encoding: NSASCIIStringEncoding error:&error];
    
    if(! googleResult ) {
        NSLog(@"Error = %@", error);
        
        return location;
    }
    
    NSArray *listItems = [googleResult componentsSeparatedByString:@","];
    
    if([listItems count] > 1 && [[listItems objectAtIndex:0] isEqualToString:@"200"]) {
        location.latitude  = [[listItems objectAtIndex:2] doubleValue];
        location.longitude = [[listItems objectAtIndex:3] doubleValue];
    }
    
    return location;
}


-(void) deduceMapCoordinatesForSelection: (NSString*) selection {    
    MKCoordinateRegion region;
    region.center = [self getCoordinatesForSelection: selection];
    region.span.latitudeDelta = 0.05f;
    region.span.longitudeDelta = 0.05f;
    
    [_mapView setRegion:region];
}


- (void)viewDidLoad
{
    [super viewDidLoad];
    
    NSString* resolved = [[PGKfzLookup sharedInstance] lookup:_selection];
    
    _selectionLabel.text = resolved;
    
    [self deduceMapCoordinatesForSelection:resolved];
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}

-(IBAction)swapToGoogleMaps:(id)sender {
    NSString* resolved = [[PGKfzLookup sharedInstance] lookup: _selection];
    NSString* url = [NSString stringWithFormat:@"http://maps.google.com/maps?q=%@", resolved];
    
    [[UIApplication sharedApplication] openURL:[NSURL URLWithString:url]];
    
}

@end
