//
//  Plotter.m
//  Console
//
//  Created by Patrick Förster on 29.02.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "Plotter.h"

@implementation Plotter

// 1) Properties
//      mit @synthesize wird der Compiler dazu veranlasst Getter- und Setter-Methode nach Definition der zugehörigen Property zu erzeugen
//      Per Default generiert der Compiler die Getter/Setter-Methoden basierend auf einem Attribut gleichen Namens. Es besteht allerdings die Möglichkeit
//      den Attributnamen und die zugehörige Property namentlich zu unterscheiden. 
@synthesize frags /* = property_name */;
@synthesize length;
@synthesize start;
@synthesize scale;
@synthesize range;

//  2) Konstruktor 
//      Es gehört "zum guten Ton", dass es nur einen Hauptkonstuktor gibt. Alle weiteren Konstruktoren "füttern" diesen Konstruktor mit den nötigen Daten. Allgemein        
//      ist daher der Konstruktor mit den meisten Argumenten zumeist auch der Hauptkonstruktor. Da innerhalb des Cocoa-Frameworks alle Klassen von NSObjekt erben,
//      sind auch die geerbten Konstruktoren gültig. Es gilt:
//          a) Gibt es in einer der überliegenen Klassen bereits einen Konstruktor der für die aktuelle Klasse ausreichend ist, sollte kein neuer angelegt werden
//          b) Falls ein neuer Hauptkonstruktor angelegt wird, muss der der Elternklasse überschrieben werden. Der neue Haupkonstruktor sollte wenn möglich den alten aufrufen.
//      Hier wird der alte Hauptkonstruktor überschrieben und "unbrauchbar" gemacht. Man könnte sich auch eine Lösung mit der Identitätsfunktion für beide Argumente vorstellen.
-(id) init {
    [self dealloc];
    
    @throw [NSException exceptionWithName:@"BadInitCall" reason:@"Init Plotter with ‘intiWithResultFunction: onArgumentFunction:‘" userInfo:nil];
}

-(id) initWithResultFunction: (res_func) f onArgumentFunction: (arg_func) g {
    if ((self = [super init])) {
        // Übergebene Werte
        rFunc = f;
        aFunc = g;
        
        // Default-Werte
        frags = 35;
        length = 2;
        scale = 10;
        start = 0;
        range.ypos = 20;
        range.yneg = -20;
    }
    
    return self;
}


-(NSString*) name {
    NSString* string = [[[NSString alloc] initWithString: NSStringFromClass([self class])] autorelease];
    
    return string;
}

-(NSString*) infos {
    NSString* string = [[[NSString alloc] initWithString: @"Diese Applikation plotted eine Funktion"] autorelease];
    
    return string;
}

-(void) fill: (NSMutableString*) string with: (NSString*) fill length: (int) l {
    NSUInteger steps = l - [string length];
    for (int k = 0; k < steps; k++) {
        [string appendString: fill];
    } 
}

-(void) run {
    for (int i = range.ypos; i >= range.yneg; i--) {
        NSMutableString* string = [NSMutableString stringWithString:@""];
        
        int end = start + (frags*length);
        
        for (int j = start; j < end; j++) {
            int y = round(rFunc(aFunc(j, frags)) * scale);
            
            if (y == i) {
                if ([string length] < j-start) {
                    [self fill: string with: i == 0 ? @"-" : @" " length: j-start];
                }
                
                [string appendString:@"o"];
            }
        }

        if ([string length] < frags*length) {
            [self fill:string with: i == 0 ? @"-" : @" " length: frags*length]; 
        }
        
        
        NSLog(@"%@", string);
    }
}

@end
