//
//  Plotter.h
//  Console
//
//  Created by Patrick Förster on 29.02.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "Phone.h"
#import "App.h"

typedef double(*res_func)(double);
typedef double(*arg_func)(int, int);
typedef struct {
    int ypos;
    int yneg;
} YRange;

//  1) Plotter Klasse implementiert das "App"-Protkoll. 
//      a) Protkolle werden in spitzen Klammern getrennt durch Kommata angegeben. 
@interface Plotter : NSObject <App/*, ...*/> {    
//    int frags;
    int length;
    int start;
    float scale;
    YRange range;
    
    res_func rFunc;
    arg_func aFunc;
}

//  2) Properties
//      in den meisten Fällen werden Attribute als @protected (default) oder gar @private deklariert. Damit ist ein Zugriff von "außerhalb" unmöglich. Um dennoch 
//      in der Lage zu sein, Attributwerte auswerten zu können, werden zumeist sogenannte Setter/Getter-Methoden deklariert, die nichts weiter tun (sollten), als 
//      den Wert eines Attributes zu setzen oder zu liefern.
//      In Objective-C besteht die Möglichkeit Setter/Getter-Methoden autogenerieren zu lassen. Dazu dienen die  Schlüsselwörter @property und @synthesize
//      
//      a) Mit @property wird eine Property definiert. Es ist nicht zwingend nötig das zugehörige Attribut auch innerhalb von {...} zu deklarieren, ein Alias kann auch mit 
//      @synthesize angegeben werden
@property int frags;
//      b) Hinter @property kann in Klammern eine durch Komma getrennte Liste von Attributen angeben werden, die spezifizieren, welches Verhalten die 
//          autogenerierten Getter/Setter-Methoden implementieren sollen
//          I) Getter:
//              1) readwrite: Getter- sowie Setter-Methoden werden implementiert (default);
//              2) readonly: Eine Getter, aber keine Setter-Methode wird implementiert
@property(readwrite) int length;
//          II) Setter:
//              1) assign: Einfach Zuweisung (default)
//              2) copy: (Nur für Objekttypen) Falls der übergebene Attributwert das NSCopying-Protokol erfüllt, so wird eine Kopie des Wertes zugewiesen. Ansonsten ist das Verhalten undefiniert.
//              3) retain/strong/weak: (Nur für Objekttypen) Zuweisung per Referenz. Die Art des Attributes gibt, wie mit der Referenz verfahren werden soll (Speichermanagement->später)
@property(assign) int start;
//          III) per default sind aller Property "atomic". D.h. in einer Multithread-Umgebung blockieren sowohl Getter- als auch Setter bis der Aufruf komplett abgeschlossen ist. Mit 
//                  "nonatomic" kann dieses Verhalten deaktiviert werden.
@property(nonatomic) float scale;
@property YRange range;

//  3) Anlegen eines individuellen Konstruktors: Konstruktor erwartet zwei Funktions-Zeiger f und g, die später zur Berechnung des y Wertes im Koordinatensystem benutzt werden
//      a) per Namenskonvention gelten Methoden die mit "init" anfangen als "Konstruktoren" (default -> init:). Dies bedeutet insbesondere, dass der Aufrufer sich um 
//          das freimachen des belegten Speicherplatzes kümmert
//      b) ansonsten unterscheiden sich Konstruktoren nicht von normalen Methoden 
-(id) initWithResultFunction: (res_func) f onArgumentFunction: (arg_func) g;

@end
