//
//  Phone.m
//  Console
//
//  Created by Patrick Förster on 15.02.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "Phone.h"

@implementation Phone

@synthesize lastNumberCalled;

// 1) Überschreiben des Konstruktors
//  a) id ist ein spezieller Datentyp der ein Pointer auf "irgendein" Objekt beinhalten kann. Die Klassenmethode "alloc" liefert einen solchen Pointer.
-(id) init {
//  b) "self" entspricht dem "this" der Java-Welt. Um den korrekten Aufbau eines Objektes zu garantieren, sollte auf jeden Fall ein Aufruf des übergeordneten Konstruktors
//      nicht fehlen. In so gut wie allen Fällen wäre es allerdings nicht nötig "self" noch zuzuweisen, man sieht es dennoch in vielen Lehrbüchern. 
//      Die Rückgabe der Initialisierung kann folgendes sein:
//          I) Pointer auf das aktuelle Objekt
//          II) "nil" für den Fall, dass "super" signalisieren möchte, dass die Initialisierung schief gelaufen ist
//          III) einen Pointer auf ein anderes Objekt
//          letztes dürfte eher selten der Fall sein, besonders für den Fall, dass die Rückgabe dann nicht mal mehr vom gleichen Typ ist (Rückgabe "id" würde das zulassen)
//          sollte allerdings die Rückgabe wirklich nicht vom gleichen oder zu mindest die Schnittstelle implementierenden Typ sein, ist auch die zu meist vorgeschlagene
//          Variante der Initialisierung nicht mehr sicher! Es könnte bspw. Nachrichten an ein Objekt gesendet werden, die von diesem überhaupt nicht verarbeitet werden
//          können.
    if ((self = [super init])) {
//  c) Initialisierung der Instanzvariablen
        lastNumberCalled = -1;
    }
     
//  d) zurück liefern der id
    return self;
}


// 2) Implementierung der Schnittstellenmethode
//      a) Innerhalb der Methode wird der Parametername zum Umgang mit den Parametern genutzt, nicht der Alias
-(void) callNumber: (int) number withMessage: (NSString*) message {
    NSLog(@"Called number %i with message: %@", number, message);
    
    lastNumberCalled = number;
}

-(int) getLastCalledNumber {
    return lastNumberCalled;
}

-(void) recallWithMessage:(NSString *)message {
    if (lastNumberCalled == -1) {
// 3) Exception throwing
        NSException* exception = [NSException exceptionWithName:@"PhoneCallException" reason:@"No number to recall available." userInfo:nil];
        @throw exception;
    }
    
    [self callNumber:lastNumberCalled withMessage:message];
}

// 4) Die "dealloc"-Methode wird automatisch aufgerufen, wenn das Objekt nicht mehr gebraucht wird. Sie sollte allerdings in keinem Fall per Hand aufgerufen werden
//      Speichermanagement
-(void) dealloc {
    NSLog(@"Deallocation of %@", self);
    
    [super dealloc];
}

// duck-typing
-(void) quak {
    NSLog(@"%@: quak", NSStringFromClass(self.class));
}

// Object-Wrapper für callNumber:(int)...
-(void) callNSNumber: (NSNumber*) number withMessage: (NSString*) message {
    [self callNumber: [number intValue] withMessage:message];
}

@end


// Helfer
@implementation CoffeeMashine 

-(void) quak {
    NSLog(@"%@: quak", NSStringFromClass(self.class));
}

-(void) dealloc {
    NSLog(@"Deallocation of %@", self);
    
    [super dealloc];
}

@end