//
//  Phone.h
//  Console
//
//  Created by Patrick Förster on 15.02.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

// 1) Ein Interface beschreibt die von außen (durch andere Klassen/Objekte) mögliche Interaktion mit dem Objekt 
//      a) Nach dem Doppelpunkt wird die Basisklasse angegeben von der die neue Klasse erben soll. 
//      b) Die Basisklasse von der alle Klassen in Cocoa erben heißt NSObject. Vererbung wird in Objective-C durch den Doppelpunkt signalisiert
@interface Phone : NSObject {
// 2) Deklaration von Instanz-Attributen
//      a) Straight-Forward: Typ + Attributname
//          es gibt drei verschiedene Sichtbarkeitseinstellungen für Attribute:
//              1) @public: auf das Attribute kann direkt von überall mit "->" zugegriffen werden: phone->lastNumberCalled± 
//              2) @protected: auf das Attribut kann nur innerhalb der Klasse und aller erbenden Klassen zugegriffen werden (default)
//              3) @private: auf das Attribut kann nur innerhalb der Klasse zugegriffen werden
    
    @protected
        int lastNumberCalled;
}

@property int lastNumberCalled;

//  3) Deklaration einer Methode
//      a) Instanz,methoden müssen mit einem "-" beginnen, Klassenmethoden mit "+"
//      b) Es gibt eine "Sichtbarkeit". Alle Methoden die im Interface deklariert werden sind "public"
//      c) Gewöhnungsbedürftige Syntax:
//          (Rückgabewert) methodenName: (Type1) alias1 param2name: (Type2) alias2 ... paramNname: (TypeN) aliasN {...}
//          Jeder Methodenparameter bis auf der erste muss mit einem Namen benannt werden! Für den ersten Parameter ist 
//          der Methodenname sozusagen der Name, weshalb ObjectiveC-Methoden meist mit der Beschreibung des ersten Parameters aufhören.
//          Generell ist das Ziel möglichst sprechende Methoden-Header zu haben. So ist die Methode nicht etwas durch den Namen, sondern
//          durch methodenName: param2name: ... paramName: deklariert (mit ":".. vor allem am Ende!)
//          hier: callNumber:withMessage:
-(void) callNumber: (int) number withMessage: (NSString*) message;

-(void) recallWithMessage: (NSString*) message;

// Getter-Methode für "lastNumberCalled"
-(int) getLastCalledNumber;

// duck-typing
-(void) quak;

// Object-Wrapper für callNumber: (int)...
-(void) callNSNumber: (NSNumber*) number withMessage: (NSString*) message;

@end

//  4) Innerhalb einer Datei können mehrere Interfaces deklariert werden. Gleiches gilt für die Implementierung
@interface CoffeeMashine : NSObject

// duck-typing
-(void) quak;

@end