//
//  PGStringDemo.m
//  Console
//
//  Created by Patrick Förster on 13.02.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGStringDemo.h"

/*
 Implementierung
 
 1) Implementieren aller Methoden, die in der zugehörigen Header-Datei definiert wurden
 */
@implementation PGStringDemo

-(void) run {
    // 1) Das obligatorische "Hello World"
    // 2) @ signalisiert dem Kompiler, dass die definierte Zeichenfolge ein Objective-C String anstelle eines C Strings (bzw. char-arrays) sein soll
    //      NSLog unterstützt nur Objective-C strings
    NSLog(@"Hello World");
    
    // 3) Definieren eines Strings
    //      Speicherplatz wird nicht explizit angefordert
    NSString* string_1 = @"Hello World";
    NSString* string_2 = @"Hello World";

    // 4) Vergleichen von Strings
    //  a) auf die falsche Art und Weise
    if (string_1 == string_2) {
        // "==" vergleicht nicht das Objekt hinter dem Zeiger, sondern die Adresse auf die der Zeiger im Heap zeigt.
        // string_1 und string_2 sind - auf den ersten Blick - als zwei verschiedene Objekte definiert
        // und dennoch ergibt der Verleich "YES" --> Der Kompilier "sieht", dass beide Zeiger durch den gleichen String definiert werden und 
        // lässt beide auf disen verweisen. 
        NSLog(@"%@ and %@ seem to be equal but they shouldn't using '=='", string_1, string_2);
    }

    //  b) die richtie Art des Vergleichs
    if ([string_1 isEqualToString:string_2]) {
        NSLog(@"So %@ and %@ really point to the same object.", string_1, string_2);
    }
    
    
    //  c) alternative
    //  "compare" vergleicht zwei Strings und liefert ein Wert des Typs "NSComparisonResult": NSOrderedAscending, NSOrderedSame, NSOrderedDescending
    if ([string_1 compare:string_2] == NSOrderedSame) {
        NSLog(@"Compare yields NSOrderedSame if the two strings are equal.");
    }
    
    // 5) einen formattierten String erstellen
    //  ein formarttierter String enthält sogenannte Platzhalter, beginnend mit % gefolgt von einem Token, dass den Typ des Platzhalters beschreibt
    //  nachfolgend werden die Zahlen 0 bis 9 auf die Konsole geloggt
    NSString* string = @"";
    NSString* temp;
    //      tidbit: for-loop
    for (int i = 0; i < 10; i++) {
        temp = [NSString stringWithFormat:@"%i", i];                    // einen temporären String erzeugen, der den Index enthält
        string = [string stringByAppendingString:temp];                 // den temporären String an den aktuellen anhängen
        if (i < 9) string = [string stringByAppendingString:@", "];     // ggf. noch ein Komma anhängen
    }
    //  tidbit: @ ist das Token für einen Zeiger-Platzhalter
    //      @-String sind Objekte! Die zugewiesene Varialbe ist demnach ein Zeiger auf NSString und werden mit @ geloggt. 
    //      NSLog erwartet allerdings einen @-String, also warum der Umweg über einen formattierten String?
    //      NSLog ist eine "vaarg" Funktion und erwartet einen undefinierte Anzahl an Parametern; mindestens einen und im Normalfall zusätzlich eben genauso viele  
    //      wie es Platzhalter im String gibt. Ein dynmaisch definierter String in Form der Übergabe eines Zeigers könnte Platzhalter enthalten, deren Werte 
    //      dann nicht mit definiert werden. C würde allerdings versuchen diese Werte zu ersetzen indem im Speicher auf die Adresse(n) nach dem String nach 
    //      den Werten für die Platzhalter geschaut wird. So kann es schnell zu "Sicherheitslöchern" kommen
    NSLog(@"%@", string);   // %@ is the token for object-pointers
    
    
    // 6) Teilbereiche 
    //  a) identifizieren: es wird so lange eine Zufallszahl (0..19) erstellt, bis diese im String vorhanden ist. 
    NSRange range = NSMakeRange(0, 0);
    NSString* search;

    //      tidbit) while-loop
    while (range.length == 0) {
        search = [NSString stringWithFormat:@"%i", rand() % 20];    
        
        range =  [string rangeOfString:search];
        
        if (range.length > 0) {
            NSLog(@"%@ found at range %lu to %lu", search, range.location, range.location + range.length);
        }
        else {
            NSLog(@"%@ not found", search);
        }
    }
    
    //  b) kopieren: kopiere den Teilstring von der Position der Zufallszahl bis zum String-Ende
    NSRange subRange = NSMakeRange(range.location, [string length] - (range.location + range.length - 1));
    
    NSLog(@"Substring starting at %@: %@", search, [string substringWithRange:subRange]);
    
    // 7) Alternative zu NSString --> NSMutableString
    //  Ein NSString-Pointer verweist mit jeder Zuweisung auf einen anderen Speicherbereich. Der String hinter dem Pointer ist unveränderbar!
    //  NSMutableString ermöglicht veränderbare String     
    NSMutableString* mutable = [NSMutableString string];
    for (int i = 0; i < 10; i++) {
        [mutable appendFormat:@"%i", i];
        if (i < 9)  [mutable appendString:@", "];    
    }
    NSLog(@"%@", mutable);
    
    //  a) Löschen des zuvor ermittelten Teilstirngs
    [mutable replaceCharactersInRange:subRange withString:@""];

    NSLog(@"String after deletion: %@", mutable);
    
    //  b) Achtung: Auch NSMutableString können direkt zugewiesen werden
    mutable = @"Stil mutable?";
    NSLog(@"%@", mutable);
    //      aber: Veränderbar ist der String nicht mehr 
    //          tidbit: exception-handling (seit Mac OS X v10.3.)
    @try {
        mutable.string = @"Test";
    }
    @catch (NSException *exception) {
        NSLog(@"The mutable string is not mutable anymore.");
    }
}

@end