//
//  PGPolyDemo.m
//  Console
//
//  Created by Patrick Förster on 29.02.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGPolyDemo.h"
#import "IPhone.h"
#import "Plotter.h"

@implementation PGPolyDemo

-(void) run {
// 1) Erstellen des IPhones und der zugehörigen Apps
    IPhone* phone = [[IPhone alloc] init];
    
    Plotter* plotter = [[Plotter alloc] initWithResultFunction:tan onArgumentFunction:piify];    
    [phone installApp:plotter];
    
    // die Verantwortung über die Plotter-Instanz wurde an das IPhone übergeben und kann hier wieder abgegeben werden.
    [plotter release];

// 2) einfache Eingabeaufforderung    
    NSFileHandle *inputHandle = [NSFileHandle fileHandleWithStandardInput];
    NSMutableString* input = nil;
    SEL infos = @selector(infos);
    while (input == nil || [input caseInsensitiveCompare:@"exit"] != NSOrderedSame) {
        
//      a) Ausgaben aller Apps
        NSLog(@" ");
        NSLog(@"index  app");
        NSInteger i = 1;
        for (id<App> app in phone.apps) {
            NSLog(@"%ld: %@ [%@]", i, [app name], [app respondsToSelector:infos] ? [app performSelector:infos] : @"-");
            
            i++;
        }
        NSLog(@" ");
        NSLog(@"==> Run app with index or type 'exit' to end this demo:");
        
        
//      b) auf Eingabe warten
        NSData* data = [inputHandle availableData];
        if(data != nil) { 
            [input release];
            
            NSString* temp = [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
            
            input = [[NSMutableString alloc] initWithString:temp];
            
            [temp release];
            
            // Return-Character der Eingabe \n entfernen
            [input deleteCharactersInRange:NSMakeRange([input length] - 1, 1)];
        }
        
//      c) Eingabe verarbeiten
        NSInteger index = [input intValue];
        
        if ([[[NSNumber numberWithLong:index] stringValue] length] != [input length]) {
            NSLog(@"==> %@ is not a number", input);
        }
        else {
            if (index <= 0 || index > [[phone apps] count]) {
                NSLog(@"==> There is no app with index %ld", index);
            }
            else {
                // run
                id<App> app = [phone getAppByIndex:index-1];
                NSLog(@"==> Running app: %@", [app name]);
                [app run];
                NSLog(@"==> Done with app: %@", [app name]);
            }
        }
    }
    
    [input release];
    [phone release];
}

@end

double piify(int steps, int frags) {
    double const pi = 3.14159265;
    
    return steps*pi/frags;
}