//
//  PGOOPDemo.m
//  Console
//
//  Created by Patrick Förster on 15.02.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGObjectDemo.h"
#import "Phone.h"               // importiere das Phone-Interface
#import "IPhone.h"

@implementation PGObjectDemo

// Helfer
-(Phone*) createPhone {
    // Erstellen einer neuen Instanz
    //      a) Dazu muss die Objektschnittstelle bekannt sein --> importieren der .h Datei, in welcher die Schnittstelle definiert wird
    //      b) mit der Klassenmethode "alloc" wird auf dem Heap der für das Objekt nötige Speicherplatz reserviert. 
    //          I) Phone* entspricht dem Datentyp "Zeiger auf ein Objekt vom Typ 'Phone'"
    //          II) Der angelegte Speicherplatz bleibt solange reserviert, bis er wieder freigegeben wird. Im iOS-Umfeld vor iOS 5 war "normal", dass der Programmierer
    //              sich um dieses "Freigeben" eigenständig kümmern muss. Mit iOS 5 wurde der Compiler um Features erweitert, welche die Speicherverwaltung vereinfachen
    //              sollen (später mehr
    //          III) die Methode "init" der Basisklasse "NSObject" entspricht dem bekannten Konstruktor-Konzept und liefert als Ergebnis das "fertige" Objekt
    //              Die "init" Methode kann natürlich beliebig überschrieben werden
    Phone* phone = [Phone alloc];
    
    [phone init];
    
    return phone;
}

-(CoffeeMashine*) createCoffeMashine {
    return [[CoffeeMashine alloc] init];
    //    return [[[CoffeeMashine alloc] init] autorelease];
}

-(void) ducktape {
    Phone* phone = [self createPhone];
    CoffeeMashine* mashine = [self createCoffeMashine];
    
    // 1) Ein einfaches, unveränderbares Array anlegen.
    //      tidbit: Man beachte, den Abschluss mit "nil", um das Ende des Arrays im Speicher festzulegen!
    NSArray* array = [[NSArray alloc] initWithObjects: phone, mashine, nil];
    
    // 2) Selektor definieren
    SEL selector = @selector(quak);
    
    // 3) duck-typig: Obwohl "Phone" und "CoffeMashine" eigentlich nichts miteinander zu tun haben, implementieren sie dennoch beide die Methode "quak". 
    for (int i = 0; i < [array count]; i++) {
        [[array objectAtIndex: i] performSelector:selector];
        
        //  aufräumen (später)
        [[array objectAtIndex:i] release];
    }
    
    // aufräumen (später)
    [array release];
}

-(void) run {
    // 1) Erstellen einer neuen Instanz
    Phone* phone = [self createPhone];
    
    // 2) Methoden/Nachrichten
    //      a) In Objective-C werden Methoden nicht direkt aufgerufen, sondern Nachrichten an Objekte gesendet mit der Bitte eine bestimmte Methode mit den
    //          mitgelieferten Parametern aufzurufen.
    //      b) Nachrichtenwünsche werden in eckigen Klammern notiert
    [phone callNumber:110 withMessage:@"I got mugged."];
    //      c) Methodenaufruf mit Rückgabe
    int lastNumberCalled = [phone getLastCalledNumber];
    NSLog(@"Last called number: %i", lastNumberCalled);    
    //      d) Wunsch zum Aufruf einer unbekannten Methoden führt nicht zum Compile- allerdings zum Laufzeitfehler
    @try {
        [phone doSomething];
    }
    @catch (NSException *exception) {}

    // 3) Der spezielle Datentyp SEL
    //      a) Ein Objekt vom Typ SEL ist ein Objekt, das die Signatur einer Methode unabhängig von Instanzen oder Klassen beschreibt; Eine solche Signatur wird in 
    //          Objective C auch "Selektor" genannt
    //      b) Instanziiert wird ein Selector mit dem Schlüsselwort "@selector"
    SEL selector = @selector(callNumber:withMessage:);
    //      c) der Selektor kann auf jedem beliebigen Objekt aufgerufen werden
    //          Allerdings unterstützt "performSelector" nur maximal zwei Argumente, die zudem vom Typ "id" sein müssen. Dabei ist Vorsicht geboten: 
    //          Als Argumente könnten Instanzen jeden Typs mitgeschickt werden. Es wird nicht überprüft oder sichergestellt, dass die Objekte den Typen der Zielparameter
    //          entsprechen:
    [phone performSelector:selector withObject:@"a string" withObject: @"Shoe"];
    //              tidbit: Lösung mit Wrapper-Methode
    [phone performSelector: @selector(callNSNumber:withMessage:) withObject:[NSNumber numberWithInt:555] withObject: @"Shoe"];    
    
    //      c) Dies macht es möglicht Nachrichten an Objekte unterschiedlicher Klasse zu versenden, ohne dass diese irgendeine Art "Schnittstelle" garantieren müssen
    [self ducktape];
    
    // 4) Nachrichten an "nil" resultieren nicht in einem Fehler! Der Nachrichtenwunsch wird ganz einfach ignoriert.
    //  tidbit: 
    //      obwohl "phone" offensichtlich zu diesem Zeitpunkt nicht mehr "existiert", schläg dieser Aufruf nicht garantiert fehl, falls phone nicht auf "nil" gesetzt wird
    phone = nil;
    [phone recallWithMessage:@"I got mugged."];
}

@end