//
//  IPhone.m
//  Console
//
//  Created by Patrick Förster on 29.02.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "IPhone.h"

@implementation IPhone

@synthesize apps = _apps;

-(id) init {
    if ((self = [super init])) {
        _apps = [[NSMutableArray alloc] initWithCapacity:5];
    }
    
    return self;
}

-(BOOL) installApp:(id<App>) app {
    if ([self isInstalledWithName:[app name]]) {
        return NO;
    }
    
    [_apps addObject:app];
    
    return YES;
}

-(BOOL) isInstalledWithName:(NSString*) appName {
    for (id<App> app in _apps) {
        if ([[app name] isEqualToString:appName]) return YES;
    }
    
    return NO;
}

-(BOOL) removeAppByName:(NSString *)appName {
    id<App> app = [self getAppByName:appName];
    
    if (app != nil) [_apps removeObject:app];
    else return NO;
    
    return YES;
}

-(id<App>) getAppByName:(NSString *)appName {
    for (id<App> app in _apps) {
        if ([[app name] isEqualToString:appName]) return app;
    }
    
    return nil;
}

-(id<App>) getAppByIndex:(NSUInteger)index {
    if (index >= [_apps count]) return nil;
    
    return [_apps objectAtIndex:index];
}

-(void) dealloc {
    [_apps release];
    
    [super dealloc];
}

@end