//
//  IPhone.h
//  Console
//
//  Created by Patrick Förster on 29.02.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "Phone.h"
#import "App.h"

//  1) Vererbung: Wie schon anhand der Basisklasse NSObject gesehen, kann die Elternklasse von der geerbt werden soll, in der @interface Zeile signalisiert durch ein Doppelpunkt angegeben werden.
//      Wie in den meisten Programmiersprachen erlaubt auch Objektive-C das erben von maximal nur einer Klasse; Mehrfachvererbung ist nicht möglich.
@interface IPhone : Phone {
    
//  2) Das IPhone beinhaltet eine beliebige Anzahln von Apps. Es besteht nicht die Möglichke ähnliche wie in Java den Datentyp des Inhalts festzulegen
    NSMutableArray* apps;
}

@property(readonly) NSMutableArray* apps;

//      id<App> garantiert, dass die Objecte hinter der id-Referenz zumindest das Protokoll <App> implementieren
-(BOOL) installApp:(id<App>) app;

-(BOOL) isInstalledWithName:(NSString*) appName;

-(BOOL) removeAppByName:(NSString*) appName;

-(id<App>) getAppByName:(NSString*) appName;

-(id<App>) getAppByIndex:(NSUInteger) index;
@end