//
//  App.h
//  Console
//
//  Created by Patrick Förster on 29.02.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

// Protokolle
//  1) analog zu Java-Interfaces definieren Protokolle in Objective-C eine Art Schnittstelle für ein Objekt, die festlegt, dass dieses Objekte eine 
//      bestimmte Menge von Operationen (Methoden) in jedem Fall und manche optional implementiert
//  2) falls das Protokoll ein bereits existierendes erweitern soll, so gibt man dieses umschlossen von <> hinter dem Prokolnamen an
@protocol App // <Protocol, ....>

//  3) alle nach dem @required definierten Methoden müssen durch Protokoll-Klassen implementiert werden
@required // default

-(NSString*) name;

-(void) run;

//  4) alle nach dem @optional definierten Methoden können, müssen aber nicht implementiert werden
//      Der Nutzen mag sich erst nicht erschließen, aber es kommt durchaus vor, dass Protokolle einen umfangreichen Satz an Methoden definieren, die 
//      durch verarbeitende Klassen aufgerufen werden. Nicht immer will man in seiner Implementierung allerdings auch den kompletten Satz unterstützen, bspw.
//      weil bestimmte Logik auf der eigenen Klasse keinen Sinn macht, die gesamte Klasse aber dennoch als "dem Protkoll entsprechend" durchgehen soll. 
//      Ohne @optional müsste jede Methode implementiert werden, so dass es zu sogenannten "Stub"-Methoden kommt, die einfach gar nichts machen, oder 
//      gar einen Fehler produzieren. Natürlich liegt der Umfang der Optionalität beim Protokoll und nicht bei der Implementierung.
@optional 

-(NSString*) infos;

@end

@interface AngryBirds : NSObject <App>

@end