//
//  PGARCDemo.m
//  ARCDemo
//
//  Created by Patrick Förster on 28.03.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGARCDemo.h"
#import "MemoryObject.h"

@implementation PGARCDemo

-(void) addToArray: (NSMutableArray*) array {
    MemoryObject* object = [MemoryObject new];
    
    [array addObject:object];    
}

-(void) motivate {
    NSLog(@"-- Test Simple Test");
    
    NSMutableArray* array = [NSMutableArray new];
    
    [self addToArray:array];
    
    NSLog(@"-- End Simple Test");
}


-(MemoryObject*) createAutoreleased {
//  Nach den alten Regeln liefert der Aufruf mit "new" ein neues Objekt in Verantwortung des Aufrufenden...
    MemoryObject* object = [MemoryObject new];
    
//  ... "autorelease" lässt sich allerdings nicht mehr aufrufen, die Verantwortung kann scheinbar also nicht abgegeben werden
//    [object autorelease]; // Compiler-Fehler!
    
    return object;
}

-(void) testAutorelease {
    NSLog(@"-- Test Autorelease");
    
    @autoreleasepool {
//  "object" wird durch eine "normale" Method erzeugt, müsste also einen Referenzzähler von eins haben und sich im aktuellen Autorelease-Pool befinden...
        MemoryObject* object = [self createAutoreleased];
        
        [object doSomething];
    }
    
    NSLog(@"-- End Autorelease");
}

-(void) testProperties {
    NSLog(@"-- Test Properties");
    MemoryObject* object = [MemoryObject new];
    
//  dieser Abschnitt ist durch einen Autorelease-Pool gekapselt, damit man im Log den Unterschied zwischen "weak" und "strong" nachvollziehen kann.
    @autoreleasepool {
        MemoryObject* buddy = [MemoryObject new];
        MemoryObject* stranger = [MemoryObject new];

//      das buddy-Property wurde als "strong" markiert
        object.buddy = buddy;
//      das stranger-Property wurde als "weak" markiert
        object.stranger = stranger;
        
//      Am Ende des Autorelease-Blocks wird stranger freigegeben!
    }
    
//      Da "stranger" als weak markiert war, ist der Wert des Zeigers nun "nil". Und Nachrichten an "nil" werden ignoiert. 
    [object.stranger doSomething];
    NSLog(@"Stranger points to: %@", object.stranger);
    
    
    NSLog(@"-- End Properties");    
}

-(void) testQualifiers {
    NSLog(@"-- Test Qualifiers");    
    
//  Analog zu den Property-Attributen "strong" und "weak" gibt es mit Qualifier die bei einer Zeiger-Deklaration angeben, welche RC-Sematik der zugehörige Zeiger haben soll.
    MemoryObject* __strong strongPtr;
    MemoryObject* __weak weakPtr;
    
    @autoreleasepool {
        MemoryObject* strongObject = [self createAutoreleased];
        MemoryObject* weakObject = [self createAutoreleased];
        
//      Diese Zuweisung an den "starken" Zeiger veranlasst, dass der Referenzähler erhöht wird. Das Objekt wird also den Autorelease-Block überleben 
        strongPtr = strongObject;

//      Diese Zuweisung wird am Referenzzähler nichts ändern. "weakObjekt" wird den Autorelease-Block nicht überleben.
        weakPtr = weakObject;
    }
    
    [strongPtr doSomething];
    [weakPtr doSomething];
    
    NSLog(@"-- End Qualifiers");    
}

//  1) ARC steht für "Automatic Reference Counting" und lässt einem fast all den Stress der manuellen Garbage Collection vergessen. Mit ARC fallen "retain", "release" und "autorelease" aus 
//      dem Wortschatz des Objektive-C Entwicklers. Aufrufe der gleichnamigen Methoden sind sogar verboten! Ab sofort kümmert sich der Compiler(!) automatisch um den Referenzzähler. 
//      Der Code wird kürzer, übersichtlicher und vor allem ist eine der größten Gefahrenquellen damit gebannt.
-(void) run {
    NSLog(@"Start ARC-Demo");
    
    [self motivate];
    [self testAutorelease];
    [self testProperties];
    [self testQualifiers];
    
    NSLog(@"End ARC-Demo");
}

@end
