//
//  MemoryObject.h
//  ARCDemo
//
//  Created by Patrick Förster on 28.03.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface MemoryObject : NSObject
        
// Property "strong": Im ARC-Umfeld ist "strong" das Synonym zu "retain". D.h. solange es einen "strong"-Zeiger auf ein Objekt gibt, bleibt dieses am Leben
@property(strong) MemoryObject* buddy;
// Property "weak": Im ARC-Umfeld ist "weak" das Synoym zu "assign". Der Referenzzähler bleibt bei Zuweisung also unangetastet. 
@property(weak) MemoryObject* stranger;

// Wichtig: Für sowohl "strong" als auch "weak" gilt, dass die Reference auf "nil" gesetzt wird, sobald das zugehörige Objekt freigegeben wird!

+(id) object;

-(void) doSomething;

@end
