//
//  PGViewController.m
//  DragMe
//
//  Created by Patrick Förster on 22.06.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>
#import "PGViewController.h"
#import "PGTileView.h"
#import "PGRssViewController.h"
#import "PGRssView.h"
#import "PGUIFactory.h"
#import "PGOperationTableViewController.h"

@implementation PGViewController

@synthesize switchAsynchronous = _switchAsynchronous;
@synthesize itemDone = _itemDone;
@synthesize buttonType = _buttonType;
@synthesize labelType = _labelType;
@synthesize page = _page;

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    _page = 0;
    _labelType.text = @"PG_DISPATCH_THREAD";
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return YES;
}

-(NSUInteger) numberOfPagesInTileView:(PGTileView *)view {
    return 3;
}

-(void) setupTile: (PGTile*) tile onPage: (PGTilePage*) page atIndex: (NSUInteger) index inView: (PGTileView*) view {

}

-(IBAction) handleSwipe:(UISwipeGestureRecognizer*)recognizer {
    PGTileView* view = ((PGTileView*)self.view);

    [view animateShift:view.frame.size.width onCurrenctPage: _page inDirection:recognizer.direction];
    
    switch (recognizer.direction) {
        case UISwipeGestureRecognizerDirectionLeft:
            if (_page < [self numberOfPagesInTileView: view]-1) _page++; 
            break;
        case UISwipeGestureRecognizerDirectionRight:
            if (_page > 0) _page--;
            break;
        default:
            break;
    }
}

-(IBAction) handleTap:(UITapGestureRecognizer*)recoginzer {
    PGTileView* view = ((PGTileView*)self.view);  
    PGTile* tile = (PGTile*) recoginzer.view;    
    
    CGRect frame = CGRectMake(
                              tile.frame.origin.x + tile.frame.size.width*0.5, 
                              tile.frame.origin.y + tile.frame.size.height*0.5, 
                              10, 10);
    
    PGRssViewController* dest = [self.storyboard instantiateViewControllerWithIdentifier:@"vc:rss"];
    UIPopoverController* popover = [[UIPopoverController alloc] initWithContentViewController:dest];
    
    dest.linkedTile = [[view getPageWithIndex:_page] tileWithIndex:tile.index];
    dest.popOverController = popover; 
    [dest prepareWithType:_labelType.text forAsynchronousInvocation:_switchAsynchronous.on];
    
    [popover setDelegate:dest];
    [popover setPopoverContentSize:CGSizeMake(600, 72)];
    [popover presentPopoverFromRect: frame inView:self.view permittedArrowDirections:UIPopoverArrowDirectionAny animated:YES];
}

- (IBAction)handlePan:(UIPanGestureRecognizer *)recognizer {
    CGPoint translation = [recognizer translationInView:self.view];
    
    recognizer.view.center = CGPointMake(recognizer.view.center.x + translation.x, recognizer.view.center.y + translation.y); 
    
    [recognizer setTranslation:CGPointMake(0, 0) inView:self.view];    
}

- (IBAction)handlePinch:(UIPinchGestureRecognizer *)recognizer {    
    PGTileView* view = ((PGTileView*)self.view);
    PGTilePage* page = [view getPageWithIndex:_page];
    
    if (recognizer.state == UIGestureRecognizerStateEnded) {
        page.transform = CGAffineTransformIdentity; 
    }
    else {
        
        page.transform = CGAffineTransformScale(page.transform, recognizer.scale, recognizer.scale);
        recognizer.scale = 1;    
    }
}

- (IBAction)handleLongPress:(UILongPressGestureRecognizer *) recognizer {
    if (!self.editing) [self onEdit:recognizer];  
}


-(IBAction)onEdit:(id)sender {
    self.editing = !self.editing;;
    
    PGTileView* view = ((PGTileView*)self.view);
    [view setEditing:self.editing];        
    
    if ([sender isKindOfClass:[UILongPressGestureRecognizer class]]) {
        UILongPressGestureRecognizer* recognizer = (UILongPressGestureRecognizer*) sender;
        
        PGTile* tile = ((PGTile*)recognizer.view);
        [tile animate:PG_TILE_ANI_EDIT_START];
    }
    
    _itemDone.title = self.editing ? @"Edit beenden" : @"Edit";
    _itemDone.tintColor = self.editing ? [UIColor redColor] : nil;
}

- (IBAction)onDelete:(id)sender {
    UIButton* button = (UIButton*) sender;
    PGTile* tile = (PGTile*) button.superview;
    
    [tile animate:PG_TILE_ANI_DELETE];    
}

- (IBAction)onSwitchChanged:(UISwitch*)sender {
    _buttonType.hidden = !sender.on;
    _labelType.hidden = !sender.on;
}

- (IBAction) onMultiLoad:(UIButton*)sender {
    PGTileView* view = ((PGTileView*)self.view);  
    PGTilePage* page = [view getPageWithIndex:_page];
    
    NSArray* tiles = [page getTiles];
    NSUInteger count = [tiles count];
    NSUInteger index = abs(arc4random() % count);
    PGTile* tile; 
    
    for (NSUInteger i = 0; i < count; i++) {
        tile = [tiles objectAtIndex:index];

        // einfach-tap auf eine kachel simulieren
        PGRssViewController* dest = [self.storyboard instantiateViewControllerWithIdentifier:@"vc:rss"];
        dest.linkedTile = tile;
        
        [dest prepareWithType:_labelType.text forAsynchronousInvocation:_switchAsynchronous.on];
        [dest viewDidAppear:YES];
        [dest onAddFeed:nil];        
        
        if (index == count-1) index = 0; else index++;
    }
}

-(void) prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    if ([segue.identifier isEqualToString:@"segue:type"]) {
        PGOperationTableViewController* dest = (PGOperationTableViewController*) segue.destinationViewController;
        
        dest.assignedLabel = _labelType;
        dest.popOverController = [(UIStoryboardPopoverSegue *)segue popoverController];
    }
}


@end
