//
//  PGTileView.m
//  DragMe
//
//  Created by Patrick Förster on 22.06.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGTileView.h"
#import "PGTilePage.h"
#import "PGDemoTile.h"

@implementation PGTileView

@synthesize delegate = _delegate;

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
    }
    return self;
}

-(PGTilePage*) createPageWithColumns: (NSInteger) xsize andRows: (NSInteger) ysize atPosition: (CGPoint) origin withStartingIndex: (NSInteger) i {
    PGTilePage* page = [[PGTilePage alloc] initWithFrame:CGRectMake(origin.x, origin.y, _pageFrame.size.width, _pageFrame.size.height)];
    
    page.delegate = _delegate;
    
    [_pageView addSubview: page];
    
    origin = CGPointMake(50, 50);
    NSInteger cellPadding = 20;
    NSInteger paddingTop = 50, paddingRight = 50, paddingBottom = 80, paddingLeft = 50;
    CGPoint offset = origin;
    
    CGSize tileSize = CGSizeMake((_pageFrame.size.width - (paddingLeft+paddingRight) - (xsize*(cellPadding+1)))/xsize, 
                                 (_pageFrame.size.height - (paddingTop+paddingBottom) - (ysize*(cellPadding+1)))/ysize); 
    
    NSInteger index = i;
    for (NSInteger i = 0; i < ysize; i++) {
        for (NSInteger j = 0; j < xsize; j++) {
            CGRect frame = CGRectMake(offset.x, offset.y, tileSize.width, tileSize.height);
            
            PGTile* tile = [[PGTile alloc] initWithFrame:frame andIndex:index++];
            
            [_delegate setupTile:tile onPage:page atIndex:index++ inView:self];
            
            UILongPressGestureRecognizer* lrRecognizer = 
            [[UILongPressGestureRecognizer alloc] initWithTarget:_delegate action:@selector(handleLongPress:)];            
            [tile addGestureRecognizer:lrRecognizer];            
            
            UITapGestureRecognizer* tapRecognizer =  [[UITapGestureRecognizer alloc] initWithTarget:_delegate action:@selector(handleTap:)];
            [tile addGestureRecognizer:tapRecognizer];
            
            /*
            UIPanGestureRecognizer* panRecoginzer = [[UIPanGestureRecognizer alloc] initWithTarget:_delegate action:@selector(handlePan:)];    
            [tile addGestureRecognizer:panRecoginzer];  
             */
                                
            [page addSubview:tile];
            
            offset = CGPointMake(offset.x + cellPadding + tileSize.width, offset.y);
        }
        
        offset = CGPointMake(origin.x, offset.y + cellPadding + tileSize.height);
    }        
    
    return page;
}

-(void) awakeFromNib {
    _pageFrame = CGRectMake(0, 0, self.frame.size.width, self.frame.size.height-50);
    _pageView = [[UIView alloc] initWithFrame:_pageFrame];
    [self addSubview:_pageView];
    
    UIPinchGestureRecognizer* pinchRecognizer = [[UIPinchGestureRecognizer alloc] initWithTarget:_delegate action:@selector(handlePinch:)];
    [_pageView addGestureRecognizer:pinchRecognizer];
    
    UISwipeGestureRecognizer* swipeRecognizer;
    
    swipeRecognizer = [[UISwipeGestureRecognizer alloc] initWithTarget:_delegate action:@selector(handleSwipe:)];
    [_pageView addGestureRecognizer:swipeRecognizer];
    swipeRecognizer.direction = UISwipeGestureRecognizerDirectionLeft;
    
    swipeRecognizer = [[UISwipeGestureRecognizer alloc] initWithTarget:_delegate action:@selector(handleSwipe:)];
    [_pageView addGestureRecognizer:swipeRecognizer];
    swipeRecognizer.direction = UISwipeGestureRecognizerDirectionRight;
        
    _pages = [_delegate numberOfPagesInTileView: self];
    _tilesInRow = 2;
    _tilesInColumn = 2;
    
    PGTilePage* page;
    for (NSInteger i = 0; i < _pages; i++) {
        page = [self createPageWithColumns:_tilesInColumn andRows:_tilesInRow 
                        atPosition: CGPointMake(self.frame.size.width * i, 0) 
                        withStartingIndex:(i*_tilesInColumn*_tilesInRow)]; 
        
        page.index = i;
    }
}

-(BOOL) editing {return _editing;}

-(void) setEditing: (BOOL) editing {
    _editing = editing;
    
    for (UIView* temp in _pageView.subviews) {
        if (![temp respondsToSelector:@selector(toggleEdit)]) continue;
        
        [temp performSelector:@selector(toggleEdit)];
    }    
}

-(PGTilePage*) getPageWithIndex: (NSInteger) index {
    for (UIView* view in _pageView.subviews) {
        if (![view isKindOfClass:[PGTilePage class]]) continue ;
        
        if (((PGTilePage*)view).index == index) return (PGTilePage*) view;
    }
    
    return nil;
}

-(void) shiftX: (CGFloat) x {
    for (UIView* temp in _pageView.subviews) {
        temp.center = CGPointMake(temp.center.x + x, temp.center.y);
    }    
}

-(void) animateEdit {
    for (UIView* temp in _pageView.subviews) {
        if (! [temp isKindOfClass:[PGTilePage class]]) return ;
        
        [((PGTilePage*)temp) animateEdit];
    }     
}

-(void) animateShift: (CGFloat) shift onCurrenctPage: (NSInteger) page inDirection: (UISwipeGestureRecognizerDirection) direction {
    BOOL temp = NO;
    if (direction == UISwipeGestureRecognizerDirectionLeft && page == _pages-1) {
        temp = YES;
    }
    
    if (direction == UISwipeGestureRecognizerDirectionRight && page == 0) {
        temp = YES;
    }
    int sign = (direction == UISwipeGestureRecognizerDirectionLeft) ? -1 : 1;
        
    [UIView animateWithDuration:.25 delay:0 options:UIViewAnimationOptionCurveEaseOut 
                     animations:^{
                         if (temp) {
                             [self shiftX:sign*shift*0.25];    
                         }
                         else {                         
                             [self shiftX:sign*shift];    
                         }
                     } 
                     completion:^(BOOL finished){
                         if (temp) {
                             UISwipeGestureRecognizerDirection d = direction == UISwipeGestureRecognizerDirectionRight ? UISwipeGestureRecognizerDirectionLeft : UISwipeGestureRecognizerDirectionRight;
                             
                             [self animateShift:shift*0.25 onCurrenctPage:-1 inDirection:d];
                         }
                     }
     ];            
}

@end
