//
//  PGTileView.h
//  DragMe
//
//  Created by Patrick Förster on 22.06.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PGTilePage.h"
#import "PGTileViewDataSource.h"

@interface PGTileView : UIView {
    BOOL _editing;
    NSUInteger _pages;
    NSUInteger _tilesInRow;
    NSUInteger _tilesInColumn;
    
    CGRect _pageFrame;
    UIView* _pageView;
}

@property(nonatomic, assign) IBOutlet id<PGTileViewDataSource> delegate;
//@property(readonly) UIView* pinchPanel;
@property(assign) BOOL editing;

-(PGTilePage*) getPageWithIndex: (NSInteger) index;

-(void) setEditing: (BOOL) editing;

-(void) shiftX: (CGFloat) x;

-(void) animateEdit;

-(void) animateShift: (CGFloat) shift onCurrenctPage: (NSInteger) page inDirection: (UISwipeGestureRecognizerDirection) direction;

@end
