//
//  PGTilePage.m
//  DragMe
//
//  Created by Patrick Förster on 24.06.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGTilePage.h"

@implementation PGTilePage

@synthesize delegate = _delegate;
@synthesize index = _index;

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
    }
    return self;
}

-(void) toggleEdit {
    for (UIView* temp in self.subviews) {
        if (![temp respondsToSelector:@selector(toggleEdit)]) continue;
        
        [temp performSelector:@selector(toggleEdit)];
    }    
}

-(void) animateEdit {
    for (UIView* temp in self.subviews) {
        if (! [temp isKindOfClass:[PGTile class]]) continue ;
        
        [((PGTile*)temp) animate:PG_TILE_ANI_EDIT];
    }     
}

-(PGTile*) tileWithIndex: (NSUInteger) index {
    for (UIView* temp in self.subviews) {
        if (! [temp isKindOfClass:[PGTile class]]) continue;
        
        PGTile* tile = (PGTile*) temp;
        
        if (tile.index == index) 
            return (PGTile*) temp;        
    }
    
    return nil;
}

-(NSArray*) getTiles {
    NSMutableArray* array = [NSMutableArray arrayWithCapacity: [self.subviews count]];
    for (UIView* temp in self.subviews) {
        if (! [temp isKindOfClass:[PGTile class]]) continue;
        
        [array addObject:temp];      
    }
    
    return array;
}

@end
