//
//  PGDraggable.m
//  DragMe
//
//  Created by Patrick Förster on 22.06.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGTile.h"
#import <QuartzCore/QuartzCore.h>
#import "PGTileView.h"
#import "PGUIFactory.h"
#import "PGTilePage.h"

@implementation PGTile

@synthesize editing = _editing;
@synthesize index = _index;

- (id)initWithFrame:(CGRect)frame andIndex: (NSUInteger) index {
    self = [super initWithFrame:frame];
    if (self) {
        _index = index;
        
        _rFactor = M_PI / 16;           
        
        // border layer
        UIView* border = [[UIView alloc] initWithFrame:CGRectMake(0, 0, self.frame.size.width, self.frame.size.height)];
        border.layer.borderWidth = 5;
        border.layer.borderColor = [[UIColor lightGrayColor] CGColor];
        border.layer.cornerRadius = 15.0f; 
        
        CGFloat r =  (rand() % 255 / 255.0f);
        CGFloat g =  (rand() % 255 / 255.0f);
        CGFloat b =  (rand() % 255 / 255.0f);        
        
        border.backgroundColor = [UIColor colorWithRed:r green:g blue:b alpha:0.5f];
        
        [self addSubview:border];
    }
    return self;
}

-(PGTilePage*) getPage {
    return (PGTilePage*) self.superview;
}

-(PGTileView*) getTileView {  // page -> pinch -> root
    return (PGTileView*) [self getPage].superview.superview;
}

-(UIView*) hitTest:(CGPoint)point withEvent:(UIEvent *)event {
    UIButton* button = (UIButton*) [self viewWithTag:100];
    if (button) {
        if ([button hitTest:point withEvent:event]) {
            [button sendActionsForControlEvents:UIControlEventTouchDown];
        }
    }
    
    return [super hitTest:point withEvent:event];
}

-(void) touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    UIButton* button = (UIButton*) [self viewWithTag:100];

    if (button) {
        UITouch *touch = [touches anyObject];        
        CGPoint point = [touch locationInView: [touch view]];
        
        if ([button hitTest:point withEvent:event]) {
            [button sendActionsForControlEvents:UIControlEventTouchDown];
        }
    }
}

-(void) toggleEdit {
    _editing = !_editing;
    
    if (_editing) {
        id delegate = [self getPage].delegate;
        
        CGRect frame = CGRectMake(-8, -8, 29, 29);
        UIButton* button = [PGUIFactory createViewFromXib:@"uitiles" widthTag:PG_TILE_DELETE andFrame:frame forOwner: delegate];
        button.tag = 100;
        [button addTarget:delegate action:@selector(onDelete:) forControlEvents:UIControlEventTouchDown];
        [self addSubview:button];
    }
    else {
        UIButton* button = (UIButton*) [self viewWithTag:100];
        [button removeFromSuperview];
    }
}

-(void) animateEditStart: (BOOL) zoomIn {
    [UIView animateWithDuration:.15
                          delay: 0
                        options:( UIViewAnimationCurveEaseOut)
                     animations: ^(void) { 
                         CGFloat scale = zoomIn ? 1.5 : 1;
                         self.transform = CGAffineTransformScale(CGAffineTransformIdentity, scale, scale);
                     }          
                     completion:^(BOOL finished) { 
                         if (finished) {
                             if (zoomIn) {
                                 [self animateEditStart:FALSE];
                             }
                             else {
                                 [[self getTileView] animateEdit];
                             }
                         }
                     }     
     
     ];      
}

-(void) animateEdit {
    [UIView animateWithDuration:.25
                          delay:0
                        options:0
                     animations: ^(void) { 
                         self.transform = CGAffineTransformRotate(self.transform, _rFactor);
                     }          
                     completion:^(BOOL finished) { 
                         if (finished && self.editing) {
                             _rFactor *= -1;
                             [self animateEdit];
                         }
                         else {
                             if (_rFactor < 0) _rFactor *= -1;
                             if (!self.editing) [self setTransform:CGAffineTransformIdentity];
                         }
                     }          
     ];    
}

-(void) animateDelete {
    [UIView animateWithDuration:.25
                          delay: 0
                        options:(UIViewAnimationCurveEaseOut)
                     animations: ^(void) { 
                         self.transform = CGAffineTransformScale(CGAffineTransformIdentity, 0.1, 0.1);
                     }          
                     completion:^(BOOL finished) { 
                         if (finished) {
                             [self removeFromSuperview];
                         }
                     }     
     
     ];         
}

-(void) animate: (PG_TILE_ANIMATION) type {
    switch (type) {
        case PG_TILE_ANI_EDIT:
            [self animateEdit];
            break;
        case PG_TILE_ANI_EDIT_START: 
            [self animateEditStart: YES];
            break;
        case PG_TILE_ANI_DELETE:
            [self animateDelete];
            break;
    }
}

@end
