//
//  PGRssViewController.m
//  DragMe
//
//  Created by Patrick Förster on 04.07.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGRssViewController.h"
#import "PGUIFactory.h"
#import "PGRssView.h"
#import "PGUIFactory.h"

@implementation PGRssViewController

@synthesize linkedTile = _linkedTile;
@synthesize popOverController = _myPopOverController;

@synthesize fieldURL = _fieldURL;

@synthesize asynchronous = _asynchronous;
@synthesize type = _type;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
}


-(void) viewDidAppear:(BOOL)animated {
    PGRssView* rssView = (PGRssView*) [_linkedTile viewWithTag:PG_RSS_XML];
    
    if (rssView) {
        [UIView animateWithDuration:0.25 animations:^(void) {
            rssView.textView.alpha = 0;
        }];    
    }
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}

-(PG_DISPATCH_OPERATION_TYPE) toOperationType: (NSString*) string {
    if ([string isEqualToString:@"PG_DISPATCH_THREAD"]) return PG_DISPATCH_THREAD;
    if ([string isEqualToString:@"PG_DISPATCH_INVOCATION"]) return PG_DISPATCH_INVOCATION;
    if ([string isEqualToString:@"PG_DISPATCH_BLOCK"]) return PG_DISPATCH_BLOCK;
    if ([string isEqualToString:@"PG_DISPATCH_CUSTOM"]) return PG_DISPATCH_CUSTOM;
    
    return -1;
}

-(void) prepareWithType: (NSString*) type forAsynchronousInvocation: (BOOL) asynchronous {
    _asynchronous = asynchronous;
    _type = [self toOperationType:type];
    
    // falls das text-feld noch nicht erzeugt wurde (passiert nur im Fall: multiload) 
    if (_fieldURL == nil) {
        UITextField* fieldURL = [[UITextField alloc] init];
        [self.view addSubview:fieldURL];
        _fieldURL = fieldURL;
    }
    
    _fieldURL.text = @"http://api.twitter.com/1/statuses/user_timeline.rss?screen_name=WWU_Muenster";      
    
    // dispatcher erstellen
    _dispatcher = [[PGLoadDispatcher alloc] initWithRssController:self]; 
}

-(BOOL) popoverControllerShouldDismissPopover:(UIPopoverController *)popoverController {
    PGRssView* rssView = (PGRssView*) [_linkedTile viewWithTag:PG_RSS_XML];
    
    if (rssView) {
        [UIView animateWithDuration:0.25 animations:^(void) {rssView.textView.alpha = 1;}];    
    }
    
    return YES;
}

-(IBAction)onAddFeed:(UIButton*)button {
    if (!_linkedTile) return ;
    
    PGRssView* rssView = (PGRssView*) [_linkedTile viewWithTag:PG_RSS_XML];
    
    // ui erstellen falls noch nicht geschehen
    if (rssView == nil) {
        CGRect frame = CGRectMake(10, 10, _linkedTile.frame.size.width-20, _linkedTile.frame.size.height-20);    
        rssView = [PGUIFactory createViewFromXib:@"uirss" widthTag:PG_RSS_XML andFrame:frame forOwner:self];
        rssView.backgroundColor = _linkedTile.backgroundColor;
        [_linkedTile addSubview: rssView];
    }
    
    // url erstellen
    NSURL* url = [NSURL URLWithString:_fieldURL.text];

    // aktivität anzeigen
    rssView.activityView.hidden = NO;
    [rssView.activityView startAnimating];
    
    // url laden
    [_dispatcher loadUrl:url asynchronous:_asynchronous asOperation:_type];

    // popover ausblenden
    [_myPopOverController dismissPopoverAnimated:YES]; 
}

-(void) onDoneLoading: (NSString*) data {
    PGRssView* rssView = (PGRssView*) [_linkedTile viewWithTag:PG_RSS_XML];
    
    [rssView.activityView stopAnimating];
    rssView.activityView.hidden = YES;

    rssView.textView.text = data;
    rssView.textView.alpha = 0;
    rssView.textView.hidden = NO;
    
    [UIView animateWithDuration:0.25 animations:^(void) {
        rssView.textView.alpha = 1;
    }];
}

-(void) onDoneParsing: (NSArray*) array {
    NSUInteger index = 1;
    NSMutableString* string = [[NSMutableString alloc] init];
    for (NSDictionary* dict in array) {
        [string appendFormat:@"Eintrag %i:\n", index++];
        [string appendString: [dict valueForKey:@"title"]];
        [string appendString:@"\n\n"];
    }
    
    [self onDoneLoading:string];
}

@end
