//
//  PGLoadDispatcher.m
//  DragMe
//
//  Created by Patrick Förster on 05.07.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGLoadDispatcher.h"
#import "PGRssViewController.h"
#import "PGRssView.h"
#import "PGUrlConnector.h"
#import "PGLoadOperation.h"
#import "PGParseOperation.h"

@implementation PGLoadDispatcher

@synthesize controller = _controller;

-(id) initWithRssController: (PGRssViewController*) controller {
    if ((self = [super init])) {
        _controller = controller;
        
        _queue = [[NSOperationQueue alloc] init];
    }
    
    return self;
}

-(void) loadUrl: (NSURL*) url asynchronous: (BOOL) asynchronous asOperation: (PG_DISPATCH_OPERATION_TYPE) operationType {        
    if (!asynchronous) {
        NSLog(@"Synchronous call start");                
        [self loadUrl:url]; 
        NSLog(@"Synchronous call end");                
    }
    else {
        switch (operationType) {
            case PG_DISPATCH_THREAD: 
                [self useThreadToLoadUrl:url];
                break;
            default:
                [self useOperation:operationType ToLoadUrl:url];
                break;
        }
    }
}

-(void) useThreadToLoadUrl: (NSURL*) url {
    NSThread* thread = [[NSThread alloc] initWithTarget:self selector:@selector(threadLoadUrl:) object:url];
     
    [thread start]; 
}

-(void) useOperation:(PG_DISPATCH_OPERATION_TYPE) type ToLoadUrl: (NSURL*) url {
    NSOperation* op;
    switch (type) {
        case PG_DISPATCH_INVOCATION: {
            op = [[NSInvocationOperation alloc] initWithTarget:self selector:@selector(invokeLoadUrl:) object:url];
            break;
        }
        case PG_DISPATCH_BLOCK: {
            op = [NSBlockOperation blockOperationWithBlock:^(void) {
                NSLog(@"Block start");                
                [self loadUrl:url];
                NSLog(@"Block ended");                
            }];
            break;
        }
        case PG_DISPATCH_CUSTOM: {
            op = [[PGLoadOperation alloc] initWithUrl:url];
            
            // KVO
            [op addObserver:self forKeyPath:@"result" options:NSKeyValueObservingOptionNew context:nil];
            [op addObserver:self forKeyPath:@"isExecuting" options:NSKeyValueObservingOptionNew context:nil];
            [op addObserver:self forKeyPath:@"isFinished" options:NSKeyValueObservingOptionNew context:nil];
            
            /*
            [op setCompletionBlock:^(void) {                
                [_controller performSelectorOnMainThread:@selector(onDoneLoading:) 
                                              withObject:((PGLoadOperation*)op).result waitUntilDone:YES]; 
            }];
             */
            
            PGParseOperation* parseOperation = [[PGParseOperation alloc] init];        
            [parseOperation addDependency:op];            
            [parseOperation setCompletionBlock:^(void) {
                [_controller performSelectorOnMainThread:@selector(onDoneParsing:) 
                                              withObject:parseOperation.entries waitUntilDone:YES]; 
            }];

             [_queue addOperation:parseOperation];
             
            break;
        }
        default:
            break;
    }
        
    [_queue addOperation:op];
}

-(void) threadLoadUrl: (NSURL*) url {
    NSLog(@"Thread start");
    [self loadUrl:url];
    NSLog(@"Thread end");    
}

-(void) invokeLoadUrl: (NSURL*) url {
    NSLog(@"Invocation start");
    [self loadUrl:url];
    NSLog(@"Invocation end");
}

-(void) loadUrl: (NSURL*) url {
    NSString* result = [PGUrlConnector loadUrl:url];
    
    [_controller performSelectorOnMainThread:@selector(onDoneLoading:) withObject:result waitUntilDone:YES]; 
}

-(void) observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context {
    if ([keyPath isEqualToString:@"result"]) {
        if ([object isKindOfClass:[PGLoadOperation class]]) {
            PGLoadOperation* op = (PGLoadOperation*) object;
            
            NSLog(@"URL %@ has been loaded", op.url);
        }        
    }
    else {    
        NSLog(@"%@ -> %@", keyPath, [change valueForKey:@"new"]);
    }
    
    if ([keyPath isEqualToString:@"isFinished"]) {
        [object removeObserver:self forKeyPath:@"result"];
        [object removeObserver:self forKeyPath:@"isFinished"];
        [object removeObserver:self forKeyPath:@"isExecuting"];
    }
}

@end
