//
//  PGKfzLookup.m
//  NavigatedViews
//
//  Created by Patrick Förster on 30.04.12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "PGKfzLookup.h"

@implementation PGKfzLookup

+(PGKfzLookup*) sharedInstance {
    static PGKfzLookup *sharedInstance = nil;
    if(!sharedInstance) {
        sharedInstance = [[PGKfzLookup alloc] init];
    }

    return sharedInstance;
}

-(id) init {
    if ((self = [super init])) {
        NSString* plistPath = [[NSBundle mainBundle] pathForResource:@"kfz" ofType:@"plist"];        
        _dictonary = [[NSMutableDictionary alloc] initWithContentsOfFile:plistPath];    
        
        _dictByLeadingCharacter = [NSMutableDictionary dictionaryWithCapacity:[_dictonary count]];
        
        for (int i = 0; i < 26; i++) {
            [_dictByLeadingCharacter setObject:[NSMutableArray array] forKey: [NSString stringWithFormat:@"%c", 65 + i]];
        }
        
        for (NSString* key in [self keys]) {
            NSString* lead = [key substringWithRange:NSMakeRange(0, 1)];
            NSMutableArray* array = [_dictByLeadingCharacter objectForKey:lead];
            
            [array addObject: key];
        }
    }
    
    return self;
}

-(NSString*) lookup:(NSString *)query {
    NSString* result = [_dictonary objectForKey:query];
    
    return result; 
}

-(BOOL) contains:(NSString*) query {
    NSString* result = [self lookup: query];
    
    return result != nil;
}

-(NSUInteger) count {
    return [_dictByLeadingCharacter count];
}

-(NSArray*) entriesForLead: (NSString*) string {
    return [_dictByLeadingCharacter objectForKey:string];
}

-(NSArray*) keys {
    return [[_dictonary allKeys] sortedArrayUsingSelector:@selector(compare:)];
}
     
@end
